from sklearn.inspection import permutation_importance

models = []
# models.append(('BNB', BernoulliNB()))
models.append(('RF', RandomForestClassifier(max_features=1, random_state=2, n_estimators=100)))
# models.append(('SVM', SVC(gamma='auto',probability=True,random_state= r)))
# models.append(('VC', VotingClassifier(estimators=[('RF', clf2), ('BNB', clf3), ('SVC', clf4)], voting='soft',weights=[2, 1, 1])))
# models.append(('NN', MLPClassifier(solver='lbfgs', alpha=1e-5, hidden_layer_sizes=(5, 2), random_state=r, max_iter=5000)))

warnings.filterwarnings("ignore", category=UserWarning, message="y_pred contains classes not in y_true")

for name, model in models:
    X = indicator_data
    Y = df_timetorain
    loocv = LeaveOneOut()
    feature_names = X.columns
    model.fit(X, Y)
    importances = model.feature_importances_
    std = np.std([tree.feature_importances_ for tree in model.estimators_], axis=0)

    result = permutation_importance(
        model, X, Y, n_repeats=10, random_state=2, n_jobs=2
    )
    forest_importances = pd.Series(result.importances_mean, index=feature_names)

feature_names = X.columns
forest_importances = pd.Series(importances, index=feature_names)

fig, ax = plt.subplots()
forest_importances.plot.bar(yerr=std, ax=ax)
ax.set_title("Feature importances using MDI")
ax.set_ylabel("Mean decrease in impurity")
fig.tight_layout()
plt.show()

fig, ax = plt.subplots()
forest_importances.plot.bar(yerr=result.importances_std, ax=ax)
ax.set_title("Feature importances using permutation on full model")
ax.set_ylabel("Mean accuracy decrease")
fig.tight_layout()
plt.show()